import tkinter as tk
from tkinter import messagebox
import base64

def encode_credentials():
    email = email_entry.get()
    token = token_entry.get()
    if not email or not token:
        messagebox.showwarning("Input Error", "Please enter both email and API token.")
        return
    credentials = f"{email}/token:{token}"
    encoded = base64.b64encode(credentials.encode('utf-8')).decode('utf-8')
    result_var.set(encoded)

def copy_to_clipboard():
    root.clipboard_clear()
    root.clipboard_append(result_var.get())
    messagebox.showinfo("Copied", "Encoded string copied to clipboard.")

# Create the main window
root = tk.Tk()
root.title("Zendesk API Base64 Encoder")

# Email input
tk.Label(root, text="Zendesk Email:").grid(row=0, column=0, sticky="e")
email_entry = tk.Entry(root, width=40)
email_entry.grid(row=0, column=1, padx=10, pady=5)

# API Token input
tk.Label(root, text="API Token:").grid(row=1, column=0, sticky="e")
token_entry = tk.Entry(root, width=40, show="*")
token_entry.grid(row=1, column=1, padx=10, pady=5)

# Encode button
encode_button = tk.Button(root, text="Generate Base64", command=encode_credentials)
encode_button.grid(row=2, column=0, columnspan=2, pady=10)

# Result display
tk.Label(root, text="Base64 Encoded String:").grid(row=3, column=0, sticky="ne")
result_var = tk.StringVar()
result_entry = tk.Entry(root, textvariable=result_var, width=60)
result_entry.grid(row=3, column=1, padx=10, pady=5)

# Copy button
copy_button = tk.Button(root, text="Copy to Clipboard", command=copy_to_clipboard)
copy_button.grid(row=4, column=0, columnspan=2, pady=10)

# Run the application
root.mainloop()
